
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 07 16:46:18 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief RC4 external application ATP tests  
   *
   *  \version CRYS_Ext_ATP_RC4_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_RC4_Acceptance.h"
#include "CRYS_Ext_ATP_RC4_Acceptance_test_vectors.h"

#include "DX_VOS_Mem.h"



extern char FailureFunctionNameOut[FailureFunctionName_K_Size];
/***** Private function prototype ******/
/******** Public Functions **********/
CRYSError_t SEPQA_ATP_CheckErrorReturn(CRYSError_t  TST_ErrorRet,
									   char         TST_FuncName[TST_FUNC_STRING_LEN],
									   char        *FailureFunctionNameOut_ptr,        
									   DxUint32_t   FuncNameMaxSize);


/******** Defines **********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ********/
/******** Public Functions **********/
/***************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_RC4_NON_integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RC4 non integrated function,
*  implemented as external SEP application                          .
*  Key size                   - 256
*  Vector sizes used (in bytes) - 512                                 
* Algorithm:       
* 1. Call the SEPQA_RC4_NotIntegrated function to execute test
* 2. Verify function succeded according to the returned error code
*
**************************/                                
CRYSError_t CRYS_ExtApp_ATP_RC4_NON_integrated ( void )
{

    /*** TST Variables Definitions ****/
    int                     TST_index = 0;
    CRYSError_t             TST_TestStatus=0;
    int                     TST_OuputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RC4_Acceptance_NON_integrated";

    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RC4_Acceptance_NON_integrated Tests ******* \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_OuputLocation =0 ; TST_OuputLocation < 2 ;TST_OuputLocation++)
    {
        for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++)     /*Select mode or operation 
                                                                                                          TST_OperationMode = 0 == Encrypt
                                                                                                          TST_OperationMode = 1 == Decrypt*/
		{           
        
            if (TST_OuputLocation == 0)/*Select output buffer*/
            {   
                /* output buffer != input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 1A.%d]  **\n",SEP_RC4_Acceptance_TestData[TST_index].TST_Name,TST_index));   
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer != input buffer                                       \n"));                    
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            }
            else
            {
                /* output buffer == input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 1B.%d]   **\n",SEP_RC4_Acceptance_TestData[TST_index].TST_Name,TST_index));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer == input buffer (output buffer)                         \n"));                      
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            }
        
            TST_TestStatus = TESTPASS;

			TST_ATP_Error = SEPQA_RC4_NotIntegrated(
				SEP_RC4_Acceptance_TestData[TST_index].TST_Key,
				SEP_RC4_Acceptance_TestData[TST_index].TST_KeySize,
				TST_ATP_EncryptDecryptFlag,
				TST_OuputLocation,
				SEP_RC4_Acceptance_TestData[TST_index].TST_input_data,
				SEP_RC4_Acceptance_TestData[TST_index].TST_dataSize,
				SEP_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data,
				SEP_RC4_Acceptance_TestData[TST_index].TST_dataSize,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RC4_NotIntegrated",FailureFunctionNameOut,TST_MasterTestName);                   
			
#if CRYS_ATP_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS) 
				return TESTFAIL;
#endif  	

                               
		}/*End of TST_ATP_EncryptDecryptFlag loop*/
        
    } /* End of TST_OuputLocation loop*/
  return TST_TestStatus;
}/* End of CRYS_Ext_ATP_RC4_Acceptance_NON_integrated*/



/*****************************************************/
/*TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR********************/
/*--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR******************/
/*TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR********************/
/*--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR******************/
/*****************************************************/

/***************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_RC4_Integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RC4 integrated function,
*  implemented as external SEP application                          .
*  Key size                   - 256
*  Vector sizes used (in bytes) - 512                                 
* Algorithm:       
* 1. Call the SEPQA_RC4_NotIntegrated function to execute test
* 2. Verify function succeded according to the returned error code
*
**************************/                                
CRYSError_t CRYS_ExtApp_ATP_RC4_Integrated ( void )
{
    /*** TST Variables Definitions ****/
    int         TST_index = 0;
    CRYSError_t TST_TestStatus=0;
    int         TST_OuputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RC4_Acceptance_Integrated";
    /*** TST Variables initialization ***/
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," *********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ** CRYS_Ext_ATP_RC4_Acceptance_Integrated Tests     ******* \n"));     
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," *********************** \n \n"));

    
    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_OuputLocation =0 ; TST_OuputLocation < 2 ;TST_OuputLocation++)
    {
        for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++) /*Select mode or operation 
                                                                                                      TST_OperationMode = 0 == Encrypt
                                                                                                      TST_OperationMode = 1 == Decrypt*/
		{
            if (TST_OuputLocation == 0)/*Select output buffer*/
            {   
                /* output buffer != input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2A.%d]  **\n",SEP_RC4_Acceptance_TestData[TST_index].TST_Name,TST_index));   
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer != input buffer                                       \n"));                    
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            }
            else
            {
                /* output buffer == input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2B.%d]   **\n",SEP_RC4_Acceptance_TestData[TST_index].TST_Name,TST_index));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer == input buffer (output buffer)                         \n"));                      
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            }
            
            TST_TestStatus = TESTPASS;

			TST_ATP_Error = SEPQA_RC4_Integrated(
				SEP_RC4_Acceptance_TestData[TST_index].TST_Key,
				SEP_RC4_Acceptance_TestData[TST_index].TST_KeySize,
				TST_ATP_EncryptDecryptFlag,
				TST_OuputLocation,
				SEP_RC4_Acceptance_TestData[TST_index].TST_input_data,
				SEP_RC4_Acceptance_TestData[TST_index].TST_dataSize,
				SEP_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data,
				SEP_RC4_Acceptance_TestData[TST_index].TST_dataSize,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RC4_Integrated",FailureFunctionNameOut,TST_MasterTestName);                   
			
#if CRYS_ATP_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS) 
				return TESTFAIL;
#endif  	


        }/* End of TST_ATP_EncryptDecryptFlag*/
        
    } /* End of TST_OuputLocation loop*/
  return TST_TestStatus;
}/* End of CRYS_Ext_ATP_RC4_Acceptance_Integrated */

/*****************************************************/
/*TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR********************/
/*--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR******************/
/*TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR********************/
/*--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR******************/
/*****************************************************/



